% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspline_init.R
\name{mspline_init}
\alias{mspline_init}
\title{Create a default M-spline model structure}
\usage{
mspline_init(
  df = 10,
  degree = 3,
  bsmooth = TRUE,
  knots = NULL,
  bknot = 10,
  obstimes = NULL
)
}
\arguments{
\item{df}{Desired number of basis terms, or "degrees of freedom"
in the spline.  If \code{knots} is not supplied, the number of
knots is then chosen to satisfy this.}

\item{degree}{Spline polynomial degree.  Can only be changed from
the default of 3 if \code{bsmooth} is \code{FALSE}.}

\item{bsmooth}{If \code{TRUE} then the function is constrained to
also have zero derivative and second derivative at the boundary.}

\item{knots}{Vector of knot locations. If not supplied, \code{df}
has to be specified.  One of two rules is then used to choose the
knot locations.  If \code{bknot} is specified, a set of equally
spaced knots between zero and \code{bknot} is used.  Otherwise
if \code{obstimes} is supplied, the knots are chosen as equally
spaced quantiles of \code{obstimes}.

The number of knots (excluding zero) is \code{df - degree + 1} if
\code{bsmooth} is \code{TRUE}, or \code{df - degree - 1}
otherwise.}

\item{bknot}{Location of the final spline knot.}

\item{obstimes}{Vector of observation times whose quantiles will be
used to choose knot locations}
}
\value{
A list with fundamental components \code{knots},
\code{degree}, and \code{bsmooth}, as documented above.

The component \code{df} is also included, and derived as a consequence
of the fundamental components.

\code{basis_means} gives the "mean" of each basis term (i.e. the
mean of a random variable whose probability density function is
given by the basis function)

\code{basis_spans} and \code{sqrt_wt} are quantities used in the
construction of random walk prior distributions for the basis
coefficients (following \url{https://arxiv.org/abs/2401.12640} and
\url{https://arxiv.org/abs/2201.06808}).
}
\description{
Create a default M-spline model structure
}
