% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{summary.survextrap}
\alias{summary.survextrap}
\title{Posterior summary statistics for parameters of survextrap models}
\usage{
\method{summary}{survextrap}(object, summ_fns = NULL, ...)
}
\arguments{
\item{object}{A fitted model object as returned by \code{\link{survextrap}}}

\item{summ_fns}{A list of functions to calculate different posterior summaries
from the MCMC sample.  This is passed to \code{\link[posterior:summarise_draws]{posterior::summarise_draws}}.
If the list is named, then the names will be used for the columns of the output.

See the examples below for different ways this can be used.

Defaults to \code{list(median = median,
                       ~quantile(.x, probs=c(0.025, 0.975)),
                       sd = sd,
                       rhat = posterior::rhat,
                       ess_bulk = posterior::ess_bulk)}

Many useful such functions are provided with the \code{posterior}
package.}

\item{...}{Summary functions can also be supplied in separate
arguments here. They will then be added to those supplied in
\code{summ_fns}.}
}
\value{
A data frame (actually a \code{tibble}) of summary
statistics for the model parameters.

The parameters, as indicated in the \code{variable} column, are:

\code{alpha}: Baseline log hazard scale.  If there are covariates, this
describes the log hazard scale with continuous covariates set to
zero, and factor covariates set to their baseline levels.  Note
that this is not the log hazard, which also depends on the spline
coefficients and basis.  See \code{\link{hazard}} to extract the
actual hazard.

\code{coefs}: Coefficients of the M-spline basis terms.  If a
non-proportional hazards model was fitted, these are with
covariates set to zero or baseline levels.

\code{loghr}: Log hazard ratios for each covariate in the model. For
cure models, this refers to covariates on survival for uncured
people.  For non-proportional hazards models, these are the
multiplicative effects of covariates on the hazard scale
parameter.  See the \href{https://chjackson.github.io/survextrap/articles/methods.html}{methods vignette}
for a full description of this model.

\code{hr}: Hazard ratios (the exponentials of \code{loghr}).

\code{pcure}: Probability of cure (for cure models only).  If there are
covariates on cure, this parameter describes the probability of
cure with continuous covariates set to zero, and factor covariates
set to their baseline levels.

\code{logor_cure}: Log odds ratio of cure for each covariate on cure.

\code{or_cure}: Odds ratios of cure (the exponentials of \code{logor_cure}).

\code{nperr}: Standardised departures from proportional hazards in the
non-proportional hazards model, defined as \eqn{b^{(np)}_{ks} /
\sigma^{(np)}_s} (see the \href{https://chjackson.github.io/survextrap/articles/methods.html}{methods vignette}
for definitions of these).

\code{hrsd}: Smoothness standard deviations \eqn{\tau_s} for the
non-proportionality effects.
}
\description{
Posterior summary statistics for parameters of
survextrap models.  The summary statistics presented by default
include the posterior median and 95\% credible intervals,
alongside the Rhat convergence diagnostic and the bulk effective
sample size (as computed by the \code{posterior} package).  For
models fitted by optimisation rather than MCMC, the posterior
mode is always returned.

Any other posterior summary can be computed if the appropriate
function to compute it is supplied in \code{summ_fns}.
}
\examples{
mod <- survextrap(Surv(years, status) ~ rx, data=colons, fit_method="opt")
summary(mod)
summary(mod, mean=mean)
summary(mod, list(mean=mean))
summary(mod, list(mean=mean, ess_tail=posterior::ess_tail))
summary(mod, mean=mean, ess_tail=posterior::ess_tail)

}
