% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymmetric_sync.R
\name{update_missing_files_asym_to_right}
\alias{update_missing_files_asym_to_right}
\title{Full asymmetric synchronization of non common files}
\usage{
update_missing_files_asym_to_right(
  left_path = NULL,
  right_path = NULL,
  sync_status = NULL,
  recurse = TRUE,
  force = TRUE,
  backup = FALSE,
  backup_dir = "temp_dir",
  copy_to_right = TRUE,
  delete_in_right = TRUE,
  exclude_delete = NULL,
  verbose = getOption("syncdr.verbose")
)
}
\arguments{
\item{left_path}{Path to the left/first directory.}

\item{right_path}{Path to the right/second directory.}

\item{sync_status}{Object of class "syncdr_status", output of \code{compare_directories()}.}

\item{recurse}{logical, TRUE by default.
If recurse is TRUE: when copying a file from source folder to destination folder, the file will be copied into the corresponding (sub)directory.
If the sub(directory) where the file is located does not exist in destination folder (or you are not sure), set recurse to FALSE,
and the file will be copied at the top level}

\item{force}{Logical. If TRUE (by default), directly perform synchronization of the directories.
If FALSE, Displays a preview of actions and prompts the user for confirmation before proceeding. Synchronization is aborted if the user does not agree.}

\item{backup}{Logical. If TRUE, creates a backup of the right directory before synchronization. The backup is stored in the location specified by \code{backup_dir}.}

\item{backup_dir}{Path to the directory where the backup of the original right directory will be stored. If not specified, the backup is stored in temporary directory (\code{tempdir}).}

\item{copy_to_right}{Logical, default is TRUE.
If TRUE, files that exist only in the left directory are copied to the right directory.
If FALSE, such files are not copied and remain absent from the right directory.}

\item{delete_in_right}{Logical, default is TRUE.
If TRUE, files that exist only in the right directory (i.e., not present in the left) are deleted.
If FALSE, these right-only files are preserved.}

\item{exclude_delete}{Character vector of file names or dir names to protect from deletion.
These files will be kept in the right directory even if \code{delete = TRUE}.}

\item{verbose}{logical. If TRUE, display directory tree before and after synchronization. Default is FALSE}
}
\value{
Invisible TRUE indicating successful synchronization.
}
\description{
update non common files in right directory based on left one -i.e., the function will:
\itemize{
\item for common_files:
\itemize{
\item do nothing, left unchanged
}
\item for non common files,
\itemize{
\item copy those files that are only in left to right
\item delete in right those files that are only in right (i.e., files 'missing in left')
}
}
}
\examples{
# Create a temporary synchronization environment
\donttest{
e <- toy_dirs()
left  <- e$left
right <- e$right

# Update missing files asymmetrically (left → right)
# Option 1: provide left and right paths
update_missing_files_asym_to_right(
  left_path  = left,
  right_path = right
)

# Option 2: provide a precomputed sync_status object
sync_status <- compare_directories(
  left_path  = left,
  right_path = right
)
update_missing_files_asym_to_right(sync_status = sync_status)
}
}
