% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_comedication_count}
\alias{plot_comedication_count}
\alias{plot_comedication_count.medic}
\alias{plot_comedication_count.summary.medic}
\alias{plot_comedication_count.comedication_count}
\title{Plot Comedication Count}
\usage{
plot_comedication_count(object, ...)

\method{plot_comedication_count}{medic}(object, ...)

\method{plot_comedication_count}{summary.medic}(object, ...)

\method{plot_comedication_count}{comedication_count}(
  object,
  scale = "percent",
  scope = "cluster",
  focus = "people",
  with_population = FALSE,
  ...
)
}
\arguments{
\item{object}{The object containing the comedication count data.}

\item{...}{Additional arguments passed to the plotting functions.}

\item{scale}{The scale of the y-axis. Must be either "percent" or "count".}

\item{scope}{The scope of the plot. Must be one of "cluster", "global" or
"medication count".}

\item{focus}{The focus of the plot. Must be either "people" or "medication".}

\item{with_population}{Logical value indicating whether to include the
population cluster.}
}
\value{
A ggplot object.
}
\description{
This function plots the comedication count.
}
\examples{
clust <- medic(complications, id = id, atc = atc, k = 3)

clust |> plot_comedication_count()
clust |> comedication_count() |> plot_comedication_count()
clust |> summary() |> plot_comedication_count()

}
\seealso{
\code{\link{comedication_count}}

\code{\link{plot_cluster_frequency}}

\code{\link{plot_medication_frequency}}

\code{\link{plot_timing_trajectory}}

\code{\link{plot_timing_atc_group}}

\code{\link{plot_summary}}
}
