% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop.R
\name{summary_crop}
\alias{summary_crop}
\alias{summary_crop.cluster_frequency}
\alias{summary_crop.medication_frequency}
\alias{summary_crop.comedication_count}
\alias{summary_crop.timing_trajectory}
\alias{summary_crop.timing_atc_group}
\alias{summary_crop.summary.medic}
\title{Crop Clustering Summary}
\usage{
summary_crop(object, ...)

\method{summary_crop}{cluster_frequency}(object, top_n = 5L, min_count = 0, min_percent = 0, ...)

\method{summary_crop}{medication_frequency}(
  object,
  top_n = 5L,
  min_count = 0,
  min_percent = 0,
  scope = "cluster",
  ...
)

\method{summary_crop}{comedication_count}(object, ...)

\method{summary_crop}{timing_trajectory}(object, sample_n_individual = 100L, weighted_sample = TRUE, ...)

\method{summary_crop}{timing_atc_group}(
  object,
  sample_n_individual = 100L,
  weighted_sample = TRUE,
  min_count = 0L,
  ...
)

\method{summary_crop}{summary.medic}(object, which = "all", ...)
}
\arguments{
\item{object}{The summary object to be cropped.}

\item{...}{Additional arguments to be passed to the specific method.}

\item{top_n}{integer. In the case of \code{cluster_frequency} it is the number of
clusters to keep. In the case of \code{medication_frequency} it is the number of
medications to keep. If \code{inf}, all clusters or medications are kept.}

\item{min_count}{integer. The minimum count of a cluster or medication to
keep it in the summary. If 0, the default, the minimum count is zero, i.e.
there is not a minimum count.}

\item{min_percent}{numeric. The minimum percentage of a cluster or medication
to keep it in the summary. If 0, the default, the minimum percentage is
zero, i.e. there is not a minimum percentage.}

\item{scope}{character. The scope of the summary crops \code{top_n}, \code{min_count}
and \code{min_percent}. The options are "cluster" and "global". The default is
"cluster". If "cluster", the crop is based on the percentage of medication
in the cluster. If "global", the crop is based on the percentage of all
medication.}

\item{sample_n_individual}{a logical or integer. If FALSE, no individual
timing trajectories are sampled. If integer, \code{sample_n_individual} is the
number of individual timing trajectories to sample. To sample all
individual timing trajectories, set \code{sample_n_individual} to \code{Inf}.}

\item{weighted_sample}{a logical, but only used if \code{sample_n_individual} is
an integer. If TRUE, the individual timing trajectories are sampled
weighted by the number of medications in the individual timing trajectory.
If FALSE, the individual timing trajectories are sampled uniformly.}

\item{which}{A character vector specifying which summaries to crop. The
options are "cluster_frequency", "medication_frequency",
"comedication_count", "timing_trajectory", and "timing_atc_group". The
default is "all".}
}
\value{
A summary object, which is a modified version of the input summary
object.
}
\description{
Functions for cropping summarized cluster data.
}
\section{\code{cluster_frequency} summary crop}{
Extracts the top \code{top_n} clusters by count. If \code{top_n} is \code{Inf}, all clusters
are kept. If \code{min_count} is greater than 0, clusters with a count less than
\code{min_count} are removed. If \code{min_percent} is greater than 0, clusters with a
percentage less than \code{min_percent} are removed. The remaining clusters are
grouped into a "Remaining" cluster.
}

\section{\code{medication_frequency} summary crop}{
Extracts the top \code{top_n} medications by count. If \code{top_n} is \code{Inf}, all
medications are kept. If \code{min_count} is greater than 0, medications with a
count less than \code{min_count} are removed. If \code{min_percent} is greater than 0,
medications with a percentage less than \code{min_percent} are removed. The
remaining medications are grouped into a "Remaining" cluster.

The \code{scope} argument determines the scope of the crop. If \code{scope} is
"cluster", the crop is based on the percentage of medication in the cluster.
If \code{scope} is "global", the crop is based on the percentage of all
medication.
}

\section{\code{comedication_count} summary crop}{
TO DO
}

\section{\code{timing_trajectory} summary crop}{
Samples \code{sample_n_individual} individual timing trajectories. If
\code{sample_n_individual} is \code{Inf}, all individual timing trajectories are kept.
If \code{weighted_sample} is \code{TRUE}, the individual timing trajectories are
sampled weighted by the number of medications in the individual timing
trajectory.
}

\section{\code{timing_atc_group} summary crop}{
Samples \code{sample_n_individual} individual timing trajectories. If
\code{sample_n_individual} is \code{Inf}, all individual timing trajectories are kept.
If \code{weighted_sample} is \code{TRUE}, the individual timing trajectories are
sampled weighted by the number of medications in the individual timing
trajectory.
}

\section{\code{summary.medic} summary crop}{
Crops multiple summaries. The \code{which} argument is a character vector
specifying which summaries to crop. The options are "cluster_frequency",
"medication_frequency", "comedication_count", "timing_trajectory", and
"timing_atc_group". If \code{which} is "all", all summaries are cropped.

The \code{...} argument is passed to the specific methods, e.g. \code{top_n} and
\code{min_count} are passed to \code{cluster_frequency} and \code{medication_frequency}.
}

\examples{
clust <- medic(
  complications,
  id = id,
  atc = atc,
  k = 3:5,
  timing = first_trimester:third_trimester
)


# Crop the cluster frequency summary
clust |>
  cluster_frequency() |>
  summary_crop(top_n = 3)

clust |>
  summary() |>
  summary_crop(which = "cluster_frequency", top_n = 3)


# Crop the medication frequency summary
clust |>
  medication_frequency() |>
  summary_crop(top_n = 3)

clust |>
  summary() |>
  summary_crop(which = "medication_frequency", top_n = 3)


# Crop the co-medication count summary
clust |>
  comedication_count() |>
  summary_crop(min_count = 10)

clust |>
  summary() |>
  summary_crop(which = "comedication_count", min_count = 10)


# crop the timing trajectory summary
clust |>
  timing_trajectory() |>
  summary_crop()

clust |>
  summary() |>
  summary_crop(which = "timing_trajectory")


# crop the timing ATC group summary
clust |>
  timing_atc_group() |>
  summary_crop()

clust |>
  summary() |>
  summary_crop(which = "timing_atc_group")

# crop multiple summaries
clust |>
  summary() |>
  summary_crop(
    which = c("cluster_frequency", "medication_frequency"),
    top_n = 3
  )

}
\seealso{
\code{\link{summary}}, \code{\link{cluster_frequency}},
\code{\link{medication_frequency}}, \code{\link{comedication_count}},
\code{\link{timing_trajectory}}, \code{\link{timing_atc_group}}
}
