% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdPRC.R
\name{tdPRC}
\alias{tdPRC}
\title{Time-dependent precision-recall curve (PRC) estimation from right-censored survival data}
\usage{
tdPRC(
  Y,
  M,
  censor,
  t,
  cut = NULL,
  len = 1000,
  h = 0.1,
  ktype = "gaussian",
  B = 0,
  alpha = 0.05,
  plot = FALSE
)
}
\arguments{
\item{Y}{The numeric vector of event-time or observed time.}

\item{M}{The numeric vector of marker values.}

\item{censor}{The censoring indicator, \code{1} if event, \code{0} otherwise.}

\item{t}{A scalar time point used to calculate the PRC curve.}

\item{cut}{A grid of cutoff values for  estimation is computed. Default is sequence of \code{151} numbers between \code{0} and \code{1}.}

\item{len}{The length of the grid points. Default is \code{151}.}

\item{h}{A scalar value for Beran's weight calculations. The default is the value obtained by using the method of Sheather and Jones (1991).}

\item{ktype}{A character string specifying the desired kernel needed for Beran weight calculation. The possible options are "\code{normal}", "\code{epanechnikov}", "\code{tricube}", "\code{boxcar}", "\code{triangular}", or "\code{quartic}". The defaults is "\code{gaussian}" kernel density.}

\item{B}{The number of bootstrap samples to be used for variance estimation. The default is \code{0}, no variance estimation.}

\item{alpha}{The significance level. The default is \code{0.05}.}

\item{plot}{The logical parameter to see the ROC curve plot. Default is \code{FALSE}.}
}
\value{
Returns the following items:

 \item{TPR }{vector of estimated TPR.}

 \item{FPR }{vector of estimated FPR.}

 \item{PPV }{vector of estimated PPV.}

 \item{AUPRC }{estimated area under the PR curve at a given time horizon \code{t}.}

 \item{AUC }{estimated area under the ROC curve at a given time horizon \code{t}.}

 \item{APbot }{estimated area under the PR curve for each bootstrap sample at a given time horizon \code{t}.}

 \item{dat }{a data frame with two columns:po = positive and M = marker.}
}
\description{
{This function empirically estimate the time-dependent precision-recall curve and RUC curve for
right censored survival data  using the cumulative sensitivity and dynamic specificity definitions.
It also calculates the time-dependent area under precision-recall curve (AUPRC) and the area under the ROC curve (AUC).
The function computes standard error and confidence interval of AUPRC and AUC using non-parametric bootstrap approach.
}
}
\examples{
library(tdPRC);

data(mayo);

data <- mayo[ ,c( "time","censor","mayoscore5" )] ;
t <- 365*6;

resu <- tdPRC(Y=data$time, M=data$mayoscore5, censor=data$censor, t=t, cut=NULL,
         len=1000, h=0.1, plot=TRUE);
resu$AUPRC

}
\references{
Beyene, K.M., Chen, D.G., and Kifle, Y.G. (2024). A novel nonparametric time‐dependent precision-recall curve estimator for right‐censored survival data. \emph{Biometrical Journal}, 66(3), 2300135.

Beyene, K.M. and El Ghouch A. (2020). Smoothed time-dependent receiver operating characteristic curve for right censored survival data. \emph{Statistics in Medicine}. 39: 3373-3396.

Li, L., Greene, T. and Hu, B. (2016).  A simple method to estimate the time-dependent receiver operating characteristic curve and the area under the curve with right censored data, \emph{Statistical Methods in Medical Research}, 27(8): 2264-2278.
}
