% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teal_report-eval_code.R
\name{eval_code-teal_report}
\alias{eval_code-teal_report}
\alias{eval_code,teal_report-method}
\title{Evaluate code in \code{qenv}}
\usage{
\S4method{eval_code}{teal_report}(object, code, code_block_opts = list(), ...)
}
\arguments{
\item{object}{(\code{teal_report})}

\item{code}{(\code{character}, \code{language} or \code{expression}) code to evaluate.
It is possible to preserve original formatting of the \code{code} by providing a \code{character} or an
\code{expression} being a result of \code{parse(keep.source = TRUE)}.}

\item{code_block_opts}{(\code{list}) Additional options for the R code chunk in R Markdown.}

\item{...}{(\code{\link{dots}}) additional arguments passed to future methods.}
}
\value{
\code{teal_reporter} environment with the code evaluated and the outputs added
to the card or \code{qenv.error} if evaluation fails.
}
\description{
Evaluate code in \code{qenv}
}
\details{
\code{eval_code()} evaluates given code in the \code{qenv} environment and appends it to the \code{code} slot.
Thus, if the \code{qenv} had been instantiated empty, contents of the environment are always a result of the stored code.
}
\examples{
td <- teal.data::teal_data()
td <- teal.code::eval_code(td, "iris <- iris")
tr <- as.teal_report(td)
tr <- teal.code::eval_code(tr, "a <- 1")
tr <- teal.code::eval_code(tr, "b <- 2L # with comment")
tr <- teal.code::eval_code(tr, quote(library(checkmate)))
tr <- teal.code::eval_code(tr, expression(assert_number(a)))
teal_card(tr)
}
\seealso{
\link[teal.code]{within.qenv}
}
