% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml_utils.R
\name{md_header}
\alias{md_header}
\title{Create \code{markdown} header from \code{yaml} string}
\usage{
md_header(x)
}
\arguments{
\item{x}{(\code{character}) \code{yaml} formatted string.}
}
\description{
This function wraps a \code{yaml}-formatted string in Markdown header delimiters.
}
\examples{
library(yaml)
yaml_quoted <- getFromNamespace("yaml_quoted", "teal.reporter")
yaml <- list(
  author = yaml_quoted("NEST"),
  title = yaml_quoted("Report"),
  date = yaml_quoted("07/04/2019"),
  output = list(pdf_document = list(keep_tex = TRUE))
)
md_header <- getFromNamespace("md_header", "teal.reporter")
md_header(as.yaml(yaml))
}
\keyword{internal}
