% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_bookmark_manager.R
\name{module_bookmark_manager}
\alias{module_bookmark_manager}
\alias{bookmark}
\alias{bookmark_manager}
\alias{bookmark_manager_module}
\alias{ui_bookmark_panel}
\alias{srv_bookmark_panel}
\alias{get_bookmarking_option}
\alias{need_bookmarking}
\title{App state management.}
\usage{
ui_bookmark_panel(id, modules)

srv_bookmark_panel(id, modules)

get_bookmarking_option()

need_bookmarking(modules)
}
\arguments{
\item{id}{(\code{character(1)}) \code{shiny} module instance id.}

\item{modules}{(\code{teal_modules})
\code{teal_modules} object. These are the specific output modules which
will be displayed in the \code{teal} application. See \code{\link[=modules]{modules()}} and \code{\link[=module]{module()}} for
more details.}
}
\value{
Invisible \code{NULL}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Capture and restore the global (app) input state.
}
\details{
This module introduces bookmarks into \code{teal} apps: the \code{shiny} bookmarking mechanism becomes enabled
and server-side bookmarks can be created.

The bookmark manager presents a button with the bookmark icon and is placed in the tab-bar.
When clicked, the button creates a bookmark and opens a modal which displays the bookmark URL.

\code{teal} does not guarantee that all modules (\code{teal_module} objects) are bookmarkable.
Those that are, have a \code{teal_bookmarkable} attribute set to \code{TRUE}. If any modules are not bookmarkable,
the bookmark manager modal displays a warning and the bookmark button displays a flag.
In order to communicate that a external module is bookmarkable, the module developer
should set the \code{teal_bookmarkable} attribute to \code{TRUE}.
}
\section{Server logic}{

A bookmark is a URL that contains the app address with a \verb{/?_state_id_=<bookmark_dir>} suffix.
\verb{<bookmark_dir>} is a directory created on the server, where the state of the application is saved.
Accessing the bookmark URL opens a new session of the app that starts in the previously saved state.
}

\section{Note}{

To enable bookmarking use either:
\itemize{
\item \code{shiny} app by using \code{shinyApp(..., enableBookmarking = "server")} (not supported in \code{shinytest2})
\item set \code{options(shiny.bookmarkStore = "server")} before running the app
}
}

\keyword{internal}
