% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/praise.R
\name{praise}
\alias{praise}
\alias{feedback}
\alias{praise_interactive}
\title{Publish praise about \pkg{texreg}}
\usage{
praise(
  academic_user,
  organization,
  name = NULL,
  general_praise = NULL,
  increase_productivity = NULL,
  increase_quality = NULL,
  start_using = NULL,
  where_learn = NULL,
  contact_details = NULL,
  models = NULL,
  num_users = NULL,
  return.response = FALSE
)

praise_interactive()
}
\arguments{
\item{academic_user}{Should be \code{TRUE} if you are at a university or
public research institute. Should be \code{FALSE} if you are a private
user, for example you are using \pkg{texreg} in your work for a firm, NGO,
association, government department, as an individual user etc. We
particularly need praise from non-academic users to demonstrate societal
impact, but we can also make the case for academic usage to generate impact
indirectly.}

\item{organization}{Please tell us the name of the organization for which you
are using \pkg{texreg}. If we can show that the package is being employed
in a number of different settings, this will help us demonstrate impact.}

\item{name}{(Optional) We would be delighted to to know who you are. After
all, we can quote you much more effectively if we can tell the funders and
employers who provided this praise! If possible, include your title.}

\item{general_praise}{Use this argument to provide general praise, for
example about the way it was designed, the user support you have received,
or just how much you enjoy using it. While this is useful, however, we
would be even more interested in receiving statements in how \pkg{texreg}
makes you more productive (in the \code{increase_productivity} argument) or
how it increases the quality of your work or your reports (through the
\code{increase_quality} argument). Note: you need to provide at least one
of these three free-form text arguments.}

\item{increase_productivity}{This is one of the fields we are most interested
in. Please use this field to tell us how \pkg{texreg} is making you more
productive. For example, does it speed up writing your articles or research
reports? Does it enable you to skip manual work like copy and paste of your
results into your reports, or to avoid fiddling with table formatting? How
much time has it saved you so far? Are there any other benefits in terms of
productivity you can think of? Note: you need to provide feedback using at
least one of the three free-form arguments (\code{general_praise},
\code{increase_productivity}, or \code{increase_quality}).}

\item{increase_quality}{This is one of the fields we are most interested in.
Please use this argument to tell us how \pkg{texreg} increases the quality
of your work or the quality of your reporting. For example, does the
package generate tables that look more professional than the tables you
used to create manually? Are you using \link{screenreg} to improve your
workflow by understanding better how the results of multiple models
compare? Are you using \link{plotreg} to visualize and present your
statistical results in a more effective way? Can you think of any other
ways in which \pkg{texreg} is helping you? Note: you need to provide
feedback using at least one of the three free-form arguments
(\code{general_praise}, \code{increase_productivity}, or
\code{increase_quality}).}

\item{start_using}{(Optional) When did you start using \pkg{texreg}? We are
interested in the approximate time or year as a free-form text argument,
for example \code{"back in 2013 when the JSS article came out"}.}

\item{where_learn}{(Optional) Where or how did you learn about the
\pkg{texreg} package?}

\item{contact_details}{(Optional) Tell us how we can contact you in case we
would benefit from additional information. This might help us further down
the road in compiling an impact case study or a similar report. Don't
worry, this information will not be displayed on the website!}

\item{models}{(Optional) Which kinds of statistical models do you use in your
work? For example, \code{"Mostly linear models, but also lme4 and ergm."}.}

\item{num_users}{(Optional) How many other \pkg{texreg} users do you know? In
particular, if you are a non-academic user, would you mind telling us how
many other non-academic users you are aware of and how many of them are in
your organization? The more we know, the more convincing our evidence base
will be. This argument accepts \code{numeric} values or more detailed
responses as a \code{character} object.}

\item{return.response}{If \code{TRUE}, a website with the submitted data will
be returned as a \code{response} object, as defined in the \pkg{httr}
package. You can load the \pkg{httr} package and use the
\code{\link[httr]{content}} function, possibly enclosed in an
\code{\link[base:character]{as.character}} call, to inspect the output and
diagnose any problems with the transmission of the data. Only use this
argument if instructed by the package authors.}
}
\value{
If everything works well, no output is returned (but see the
  \code{return.response} argument to change this). If the submission of the
  praise to the maintainer fails, a \code{response} object (as defined in the
  \pkg{httr} package) will be returned. Should you have any problems, do feel
  free to e-mail your praise to the package maintainer directly.
}
\description{
Publish praise about \pkg{texreg} to help the developers demonstrate impact.
}
\details{
The \code{\link{praise_interactive}} function asks you 11 questions
interactively on the R console. You can choose to answer or skip them. Some
questions are mandatory but most are optional. After collecting your answers,
it will call the \code{\link{praise}} function to submit your praise. You can
also choose to use the \code{\link{praise}} function directly and supply your
answers as arguments. Either way is fine.

Before your praise is submitted, the functions will present an interactive
menu and ask if you want to submit the praise now. So do not worry about
accidentally submitting feedback.

You can use these functions to praise the \pkg{texreg} package. Funders and
academic employers are increasingly interested in seeing evidence for the
impact academic research generates. For software, such as \pkg{texreg}, this
is very hard to accomplish because the developers are usually disconnected
from the users. The consequence is that incentives for developing
packages like these are diminishing the more the funders and employers
require evidence of impact on society, firms, or policy makers.

The \code{\link{praise}} and \code{\link{praise_interactive}} functions are
our attempt at rectifying the situation. With these functions, you can
provide positive feedback to the developers. The praise is saved to a
database on the web server of the package maintainer and subsequently
displayed at \url{https://www.philipleifeld.com/praise/} for other users,
funders, and employers to view. This will also enable the package authors to
compile reports about how \pkg{texreg} is used by academic and non-academic
users to increase their productivity and work quality, for example in the
form of an impact case study for the next round of the UK Research Excellence
Framework (REF).

We need many positive examples of how \pkg{texreg} has an impact on your
work. We are especially interested in non-academic users, but welcome
feedback from anyone. So please contribute by using the praise function! Tell
us how cool this package is and how it has changed your work!

The minimal information we require from you is whether you are an academic or
non-academic user, the name of your organization, and some free-form praise
(of a general nature, or about how it makes you more productive, or about how
it increases the quality of your work or reporting). But there are some
additional fields. While we are happy with the basic information, of course
we will be happier if we also know your name, how to contact you, what kinds
of models you work with, and some other details. Your choice!

Please note that by using the \code{\link{praise}} or
\code{\link{praise_interactive}} function you agree that the information you
provide through the function, including your approximate location, is stored
online in a database, displayed on the website of the package author, and
used in reports to funders, employers etc. (This is the whole purpose of it.)
You can contact the package maintainer any time to have your praise removed
within a few days.
}
\examples{
\dontrun{
praise(academic_user = TRUE,
       organization = "University of Happy Tables",
       increase_quality = "Man, I've never seen such pretty tables!")
}

}
\author{
Philip Leifeld
}
