% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lorem_text.R
\name{lorem_text}
\alias{lorem_text}
\alias{lorem_bidi}
\title{Get gibberish text in various scripts}
\usage{
lorem_text(
  script = c("latin", "chinese", "arabic", "devanagari", "cyrillic", "kana", "hangul",
    "greek", "hebrew", "armenian", "georgian"),
  n = 1
)

lorem_bidi(
  ltr = c("latin", "chinese", "devanagari", "cyrillic", "kana", "hangul", "greek",
    "armenian", "georgian"),
  rtl = c("arabic", "hebrew"),
  ltr_prop = 0.9,
  n = 1
)
}
\arguments{
\item{script}{A string giving the script to fetch gibberish for}

\item{n}{The number of paragraphs to fetch. Each paragraph will be its own
element in the returned character vector.}

\item{ltr, rtl}{scripts to use for left-to-right and right-to-left text}

\item{ltr_prop}{The approximate proportion of left-to-right text in the final
string}
}
\value{
a character vector of length \code{n}
}
\description{
Textshaping exists partly to allow all the various scripts that exists in the
world to be used in R graphics. This function returns gibberish filler text
(lorem ipsum text) in various scripts for testing purpose. Some of these are
transliterations of the original lorem ipsum text while others are based an
a distribution model.
}
\examples{
# Defaults to standard lorem ipsum
lorem_text()

# Get two paragraphs of hangul (Korean)
lorem_text("hangul", 2)

# Get gibberish bi-directional text
lorem_bidi()

}
\references{
https://generator.lorem-ipsum.info
}
