% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts.R
\name{sts_semi_local_linear_trend}
\alias{sts_semi_local_linear_trend}
\title{Formal representation of a semi-local linear trend model.}
\usage{
sts_semi_local_linear_trend(
  observed_time_series = NULL,
  level_scale_prior = NULL,
  slope_mean_prior = NULL,
  slope_scale_prior = NULL,
  autoregressive_coef_prior = NULL,
  initial_level_prior = NULL,
  initial_slope_prior = NULL,
  constrain_ar_coef_stationary = TRUE,
  constrain_ar_coef_positive = FALSE,
  name = NULL
)
}
\arguments{
\item{observed_time_series}{optional \code{float} \code{tensor} of shape
\verb{batch_shape + [T, 1]} (omitting the trailing unit dimension is also
supported when \code{T > 1}), specifying an observed time series.
Any priors not explicitly set will be given default values according to
the scale of the observed time series (or batch of time series). May
optionally be an instance of \code{sts_masked_time_series}, which includes
a mask \code{tensor} to specify timesteps with missing observations.
Default value: \code{NULL}.}

\item{level_scale_prior}{optional \code{tfp$distribution} instance specifying a prior
on the \code{level_scale} parameter. If \code{NULL}, a heuristic default prior is
constructed based on the provided \code{observed_time_series}.
Default value: \code{NULL}.}

\item{slope_mean_prior}{optional \code{tfd$Distribution} instance specifying a prior
on the \code{slope_mean} parameter. If \code{NULL}, a heuristic default prior is
constructed based on the provided \code{observed_time_series}. Default value: \code{NULL}.}

\item{slope_scale_prior}{optional \code{tfd$Distribution} instance specifying a prior
on the \code{slope_scale} parameter. If \code{NULL}, a heuristic default prior is
constructed based on the provided \code{observed_time_series}. Default value: \code{NULL}.}

\item{autoregressive_coef_prior}{optional \code{tfd$Distribution} instance specifying
a prior on the \code{autoregressive_coef} parameter. If \code{NULL}, the default
prior is a standard \code{Normal(0, 1)}. Note that the prior may be
implicitly truncated by \code{constrain_ar_coef_stationary} and/or \code{constrain_ar_coef_positive}.
Default value: \code{NULL}.}

\item{initial_level_prior}{optional \code{tfp$distribution} instance specifying a
prior on the initial level. If \code{NULL}, a heuristic default prior is
constructed based on the provided \code{observed_time_series}.
Default value: \code{NULL}.}

\item{initial_slope_prior}{optional \code{tfd$Distribution} instance specifying a
prior on the initial slope. If \code{NULL}, a heuristic default prior is
constructed based on the provided \code{observed_time_series}. Default value: \code{NULL}.}

\item{constrain_ar_coef_stationary}{if \code{TRUE}, perform inference using a
parameterization that restricts \code{autoregressive_coef} to the interval
\verb{(-1, 1)}, or \verb{(0, 1)} if \code{force_positive_ar_coef} is also \code{TRUE},
corresponding to stationary processes. This will implicitly truncate
the support of \code{autoregressive_coef_prior}. Default value: \code{TRUE}.}

\item{constrain_ar_coef_positive}{if \code{TRUE}, perform inference using a
parameterization that restricts \code{autoregressive_coef} to be positive,
or in \verb{(0, 1)} if \code{constrain_ar_coef_stationary} is also \code{TRUE}. This
will implicitly truncate the support of \code{autoregressive_coef_prior}.
Default value: \code{FALSE}.}

\item{name}{the name of this model component. Default value: 'SemiLocalLinearTrend'.}
}
\value{
an instance of \code{StructuralTimeSeries}.
}
\description{
Like the \code{sts_local_linear_trend} model, a semi-local linear trend posits a
latent \code{level} and \code{slope}, with the level component updated according to
the current slope plus a random walk:
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{level[t] = level[t-1] + slope[t-1] + Normal(0., level_scale)
}\if{html}{\out{</div>}}

The slope component in a \code{sts_semi_local_linear_trend} model evolves according to
a first-order autoregressive (AR1) process with potentially nonzero mean:

\if{html}{\out{<div class="sourceCode">}}\preformatted{slope[t] = (slope_mean + autoregressive_coef * (slope[t-1] - slope_mean) + Normal(0., slope_scale))
}\if{html}{\out{</div>}}

Unlike the random walk used in \code{LocalLinearTrend}, a stationary
AR1 process (coefficient in \verb{(-1, 1)}) maintains bounded variance over time,
so a \code{SemiLocalLinearTrend} model will often produce more reasonable
uncertainties when forecasting over long timescales.
}
\seealso{
For usage examples see \code{\link[=sts_fit_with_hmc]{sts_fit_with_hmc()}}, \code{\link[=sts_forecast]{sts_forecast()}}, \code{\link[=sts_decompose_by_component]{sts_decompose_by_component()}}.

Other sts: 
\code{\link{sts_additive_state_space_model}()},
\code{\link{sts_autoregressive}()},
\code{\link{sts_autoregressive_state_space_model}()},
\code{\link{sts_constrained_seasonal_state_space_model}()},
\code{\link{sts_dynamic_linear_regression}()},
\code{\link{sts_dynamic_linear_regression_state_space_model}()},
\code{\link{sts_linear_regression}()},
\code{\link{sts_local_level}()},
\code{\link{sts_local_level_state_space_model}()},
\code{\link{sts_local_linear_trend}()},
\code{\link{sts_local_linear_trend_state_space_model}()},
\code{\link{sts_seasonal}()},
\code{\link{sts_seasonal_state_space_model}()},
\code{\link{sts_semi_local_linear_trend_state_space_model}()},
\code{\link{sts_smooth_seasonal}()},
\code{\link{sts_smooth_seasonal_state_space_model}()},
\code{\link{sts_sparse_linear_regression}()},
\code{\link{sts_sum}()}
}
\concept{sts}
