% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts.R
\name{sts_sum}
\alias{sts_sum}
\title{Sum of structural time series components.}
\usage{
sts_sum(
  observed_time_series = NULL,
  components,
  constant_offset = NULL,
  observation_noise_scale_prior = NULL,
  name = NULL
)
}
\arguments{
\item{observed_time_series}{optional \code{float} \code{tensor} of shape
\verb{batch_shape + [T, 1]} (omitting the trailing unit dimension is also
supported when \code{T > 1}), specifying an observed time series.
Any priors not explicitly set will be given default values according to
the scale of the observed time series (or batch of time series). May
optionally be an instance of \code{sts_masked_time_series}, which includes
a mask \code{tensor} to specify timesteps with missing observations.
Default value: \code{NULL}.}

\item{components}{\code{list} of one or more StructuralTimeSeries instances.
These must have unique names.}

\item{constant_offset}{optional scalar \code{float} \code{tensor}, or batch of scalars,
specifying a constant value added to the sum of outputs from the
component models. This allows the components to model the shifted series
\code{observed_time_series - constant_offset}. If \code{NULL}, this is set to the
mean of the provided \code{observed_time_series}. Default value: \code{NULL}.}

\item{observation_noise_scale_prior}{optional \code{tfd$Distribution} instance
specifying a prior on \code{observation_noise_scale}. If \code{NULL}, a heuristic
default prior is constructed based on the provided
\code{observed_time_series}. Default value: \code{NULL}.}

\item{name}{string name of this model component; used as \code{name_scope}
for ops created by this class. Default value: 'Sum'.}
}
\value{
an instance of \code{StructuralTimeSeries}.
}
\description{
This class enables compositional specification of a structural time series
model from basic components. Given a list of component models, it represents
an additive model, i.e., a model of time series that may be decomposed into a
sum of terms corresponding to the component models.
}
\details{
Formally, the additive model represents a random process
\code{g[t] = f1[t] + f2[t] + ... + fN[t] + eps[t]}, where the \code{f}'s are the
random processes represented by the components, and
\code{eps[t] ~ Normal(loc=0, scale=observation_noise_scale)} is an observation
noise term. See the \code{AdditiveStateSpaceModel} documentation for mathematical details.

This model inherits the parameters (with priors) of its components, and
adds an \code{observation_noise_scale} parameter governing the level of noise in
the observed time series.
}
\seealso{
For usage examples see \code{\link[=sts_fit_with_hmc]{sts_fit_with_hmc()}}, \code{\link[=sts_forecast]{sts_forecast()}}, \code{\link[=sts_decompose_by_component]{sts_decompose_by_component()}}.

Other sts: 
\code{\link{sts_additive_state_space_model}()},
\code{\link{sts_autoregressive}()},
\code{\link{sts_autoregressive_state_space_model}()},
\code{\link{sts_constrained_seasonal_state_space_model}()},
\code{\link{sts_dynamic_linear_regression}()},
\code{\link{sts_dynamic_linear_regression_state_space_model}()},
\code{\link{sts_linear_regression}()},
\code{\link{sts_local_level}()},
\code{\link{sts_local_level_state_space_model}()},
\code{\link{sts_local_linear_trend}()},
\code{\link{sts_local_linear_trend_state_space_model}()},
\code{\link{sts_seasonal}()},
\code{\link{sts_seasonal_state_space_model}()},
\code{\link{sts_semi_local_linear_trend}()},
\code{\link{sts_semi_local_linear_trend_state_space_model}()},
\code{\link{sts_smooth_seasonal}()},
\code{\link{sts_smooth_seasonal_state_space_model}()},
\code{\link{sts_sparse_linear_regression}()}
}
\concept{sts}
