% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel_fix.R
\name{panel_fix}
\alias{panel_fix}
\alias{panel_fix_overall}
\title{Set the panel width/height of a plot to a fixed value}
\usage{
panel_fix(
  x = NULL,
  panel_index = NULL,
  respect = NULL,
  width = NULL,
  height = NULL,
  margin = 1,
  padding = 0,
  units = "in",
  raster = FALSE,
  dpi = 300,
  return_grob = FALSE,
  bg_color = "white",
  save = NULL,
  verbose = FALSE,
  ...
)

panel_fix_overall(
  x,
  panel_index = NULL,
  respect = NULL,
  width = NULL,
  height = NULL,
  margin = 1,
  units = "in",
  raster = FALSE,
  dpi = 300,
  return_grob = FALSE,
  bg_color = "white",
  save = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{A ggplot object, a grob object, or a combined plot made by patchwork or cowplot package.}

\item{panel_index}{Specify the panel to be fixed.
If \code{NULL}, will fix all panels.}

\item{respect}{Whether row heights and column widths should respect each other.}

\item{width}{The desired width of the fixed panels.}

\item{height}{The desired height of the fixed panels.}

\item{margin}{The margin to add around each panel, in inches.
Default is \code{1}.}

\item{padding}{The padding to add around each panel, in inches.
Default is \code{0}.}

\item{units}{The units in which \code{height}, \code{width} and \code{margin} are given.
Can be \code{"mm"}, \code{"cm"}, \code{"in"}, etc. See \link[grid:unit]{grid::unit}.}

\item{raster}{Whether to rasterize the panel.}

\item{dpi}{Plot resolution.}

\item{return_grob}{Whether to return a grob object instead of a wrapped \code{patchwork} object.
Default is \code{FALSE}.}

\item{bg_color}{The background color of the plot.}

\item{save}{\code{NULL} or the file name used to save the plot.}

\item{verbose}{Whether to print the message.
Default is \code{TRUE}.}

\item{...}{Additional arguments passed to other functions.}
}
\value{
If \code{return_grob} is \code{TRUE}, returns a gtable object.
Otherwise, returns a patchwork object with fixed panel sizes.
The returned object has a \code{size} attribute containing width, height, and units.
}
\description{
The ggplot object, when stored, can only specify the height and width of the entire plot, not the panel.
The latter is obviously more important to control the final result of a plot.
This function can set the panel width/height of plot to a fixed value and rasterize it.
}
\examples{
library(ggplot2)
p <- ggplot(
  data = mtcars, aes(x = mpg, y = wt, colour = cyl)
) +
  geom_point() +
  facet_wrap(~gear, nrow = 2)
# fix the size of panel
panel_fix(
  p,
  width = 5,
  height = 3,
  units = "cm"
)
# rasterize the panel
panel_fix(
  p,
  width = 5,
  height = 3,
  units = "cm",
  raster = TRUE,
  dpi = 90
)

# `panel_fix` will build and render the plot when input a ggplot object.
# so after `panel_fix`, the size of the object will be changed.
object.size(p)
object.size(
  panel_fix(
    p,
    width = 5,
    height = 3,
    units = "cm"
  )
)
}
