% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_weibull.R
\name{iweibull}
\alias{iweibull}
\alias{mweibull}
\alias{parameters_weibull}
\title{Weibull distribution functions}
\usage{
iweibull(x, shape, scale = 1)

mweibull(x, shape, scale = 1)

parameters_weibull(...)
}
\arguments{
\item{x}{A numeric vector}

\item{shape}{Shape parameter for Weibull distribution. See \code{\link[stats:Weibull]{stats::dweibull()}}.}

\item{scale}{Scale parameter for Weibull distribution. See \code{\link[stats:Weibull]{stats::dweibull()}}.}

\item{...}{currently ignored}
}
\value{
A numeric vector
}
\description{
Weibull distribution functions
}
\details{
Intensity function for the Weibull distribution.
\deqn{
   iweibull(x) = \left( \frac{shape}{scale} \right) \cdot 
                 \left( \frac{x}{scale} \right)^{shape - 1}
 }

Mean intensity function for the Weibull distribution.
\deqn{
   mweibull(x) = \left( \frac{x}{scale} \right)^{shape}
 }

\code{\link[=parameters_weibull]{parameters_weibull()}} returns a \code{list()} with two components: \code{shape}
and \code{scale}, each of which is a \code{list()} of distribution parameters.
These parameters are used to define the prior distributions for the
hyperparameters.
}
\examples{
# Compute the intensities and plot them
iweibull(1, shape = 1, scale = 1)
plot(x = 1:10, y = iweibull(1:10, shape = 2, scale = 2))

# Compute various values of the distribution
mweibull(1, shape = 1, scale = 1)
plot(x = 1:10, y = mweibull(1:10, shape = 1, scale = 1))
plot(x = 1:10, y = mweibull(1:10, shape = 1, scale = 2))
plot(x = 1:10, y = mweibull(1:10, shape = 0.5, scale = 2))
plot(x = 1:10, y = mweibull(1:10, shape = 0.5, scale = 100))
plot(x = 1:10, y = mweibull(1:10, shape = 2, scale = 2))
plot(x = 1:10, y = mweibull(1:10, shape = 2, scale = 100))

# Generate prior distribution hyperparameters
parameters_weibull()

}
\seealso{
\code{\link[stats:Weibull]{stats::dweibull()}}

\code{\link[stats:GammaDist]{stats::dgamma()}}
}
