% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{get_country_info}
\alias{get_country_info}
\title{get_country_info}
\usage{
get_country_info(country_value, geometry = FALSE)
}
\arguments{
\item{country_value}{A character string representing the country code(cca2 or cca3) or common name. The input is case-insensitive.
If "all" is passed, the function return data for all countries.}

\item{geometry}{Logical. If \code{TRUE}, includes spatial geometry data for the country (boundaries).
Defaults to \code{FALSE}. When \code{TRUE}, an additional column for geographic boundaries  is included.}
}
\value{
A data frame with selected country information. If \code{geometry = TRUE}, the result includes a geometry column
with boundary data, making the returned object ready to be converted to an \code{sf} (simple features) data frame for spatial analysis.
If the input is "all", it returns data for all countries. If no match is found, a list of all available country names is printed.
}
\description{
This function retrieves information about a specific country based on its country code (cca2 or cca3) or common name.
The function is case-insentive and provides a comprehensive overview of the selected country
If "all" is passed as the input, it returns data for all countries. If the input does not match any country,
the function returns a list of all available country names.
}
\note{
The returned data frame includes relevant country details. If \code{geometry = TRUE}, an additional column for geographic boundaries  is included.
}
\examples{
\donttest{
# Examples usage: Get information for Nigeria
nigeria_info <- get_country_info("Nigeria")
print(nigeria_info)

# Example usage: Get information for a country using it's cca2 code
usa_info <- get_country_info("US")
print(usa_info)
}
}
