% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_model.R
\name{get_model}
\alias{get_model}
\title{Get a fitted model from a tidyfit.models frame}
\usage{
get_model(df, ..., .first_row = TRUE)
}
\arguments{
\item{df}{a tidyfit.models frame created using m(), regress(), classify() and similar methods}

\item{...}{arguments passed to \code{dplyr::filter} to filter row in 'df' for which the model should be returned. filters can also include columns nested in \code{df$settings}.}

\item{.first_row}{should the first row be returned if the (filtered) df contains multiple rows}
}
\value{
An object of the class associated with the underlying fitting algorithm
}
\description{
Returns a single fitted model object produced by the underlying fitting algorithm from a tidyfit.models frame based on a given row number.
}
\details{
This method is a utility to return the object fitted by the underlying algorithm. For instance, when \code{m("lm")} is used to create the tidyfit.models frame, the returned object is of class "lm".
}
\examples{
# Load data
data("mtcars")

# fit separate models for transmission types
mtcars <- dplyr::group_by(mtcars, am)

fit <- regress(mtcars, mpg ~ ., m("lm"))

# get the model for single row
summary(get_model(fit, am == 0))

# get model by row number
summary(get_model(fit, dplyr::row_number() == 2))

}
\seealso{
\code{\link{get_tidyFit}} method
}
\author{
Johann Pfitzinger
}
