% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_factory.R
\name{get_api_query}
\alias{get_api_query}
\title{Construct a geocoder API query}
\usage{
get_api_query(method, generic_parameters = list(), custom_parameters = list())
}
\arguments{
\item{method}{the geocoding service name (ie. 'census')}

\item{generic_parameters}{universal "generic" parameters}

\item{custom_parameters}{custom api-specific parameters}
}
\value{
API parameters as a named list
}
\description{
The geocoder API query is created using universal "generic" parameters
and optional api-specific "custom" parameters. Generic parameters
are converted into api parameters using the  \link{api_parameter_reference}
dataset.

The \link{query_api} function executes the queries created
by this function.
}
\examples{
get_api_query("osm", list(address = "Hanoi, Vietnam"))

get_api_query(
  "census", list(street = "11 Wall St", city = "NY", state = "NY"),
  list(benchmark = "Public_AR_Census2010")
)

}
\seealso{
\link{query_api} \link{api_parameter_reference} \link{geo} \link{reverse_geo}
}
