% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qoi.R
\name{calculate_ate}
\alias{calculate_ate}
\title{Calculates a SATE and a PATE using AIPW}
\usage{
calculate_ate(data)
}
\arguments{
\item{data}{The dataset of interest after it has been prepared fully.}
}
\description{
This function takes fully prepared data (with all auxilliary columns from the
necessary models) and estimates average treatment effects using AIPW.
}
\references{
\itemize{
\item Kennedy, E. H. (2020). Towards optimal doubly robust estimation of heterogeneous
causal effects. \emph{arXiv preprint arXiv:2004.14497}.
\item Tsiatis, A. A., Davidian, M., Zhang, M., & Lu, X. (2008). Covariate adjustment
for two‐sample treatment comparisons in randomized clinical trials: a principled
yet flexible approach. \emph{Statistics in medicine}, 27(23), 4658-4677.
}
}
\seealso{
\code{\link[=basic_config]{basic_config()}}, \code{\link[=attach_config]{attach_config()}}, \code{\link[=make_splits]{make_splits()}}, \code{\link[=produce_plugin_estimates]{produce_plugin_estimates()}},
\code{\link[=construct_pseudo_outcomes]{construct_pseudo_outcomes()}}, \code{\link[=estimate_QoI]{estimate_QoI()}}
}
\keyword{internal}
