% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getaklips.R
\name{getaklips}
\alias{getaklips}
\title{`getaklips()' is used to obtain data.frame for KLIPS (additional survey)}
\usage{
getaklips(
  path,
  year,
  datatype = c("stata", "spss", "sas", "xlsx"),
  klipsvars = c("6101", "6102"),
  outvars = c("activity", "howmayactivity")
)
}
\arguments{
\item{path}{A string vector specifying folder containing KLIPS additional survey data}

\item{year}{an integer vector  specifying the years from 1998 to 2023 that the user wants to include in the dataframe.}

\item{datatype}{A string vector specifying the format of the raw data you want to convert to a data frame ("spss", "sas", "stata", "excel")}

\item{klipsvars}{A string vector specifying the variables in the raw data that you want to convert to a data frame ("6101", "6102")}

\item{outvars}{A string vector specifying the variable names of converted data ("acivity", "howmayactivity")}
}
\value{
A data frame containing klips household member data with the specified years and variables.
\itemize{
\item \code{getaklips()} returns an integer dataframe with two and more columns and
rows for each respondent. The first column, \code{pid},
refers to the respondent id number, and the last column, \code{year},
refers to the year that the user wants to include in the dataframe.
}
}
\description{
`getaklips()' is used to obtain data.frame for KLIPS (additional survey)
}
\examples{

path <- system.file("extdata", package = "tidyklips")
df <- getaklips(path = path, year = 2023, datatype = "stata")
df \%>\%
  dplyr::group_by(year, activity) \%>\%
  dplyr::summarise(count = dplyr::n()) \%>\%
  dplyr::mutate(proportion = count / sum(count))


}
