% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-general.R
\name{add_mean_bar}
\alias{add_mean_bar}
\alias{add_mean_dash}
\alias{add_mean_dot}
\alias{add_mean_value}
\alias{add_mean_line}
\alias{add_mean_area}
\title{Add mean}
\usage{
add_mean_bar(
  plot,
  dodge_width = NULL,
  width = 0.6,
  saturation = 1,
  preserve = "total",
  ...
)

add_mean_dash(
  plot,
  dodge_width = NULL,
  width = 0.6,
  linewidth = 0.25,
  preserve = "total",
  ...
)

add_mean_dot(plot, dodge_width = NULL, size = 2, preserve = "total", ...)

add_mean_value(
  plot,
  dodge_width = NULL,
  accuracy = 0.1,
  scale_cut = NULL,
  fontsize = 7,
  extra_padding = 0.15,
  vjust = NULL,
  hjust = NULL,
  preserve = "total",
  ...
)

add_mean_line(
  plot,
  group,
  dodge_width = NULL,
  linewidth = 0.25,
  preserve = "total",
  ...
)

add_mean_area(
  plot,
  group,
  dodge_width = NULL,
  linewidth = 0.25,
  preserve = "total",
  ...
)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{dodge_width}{For adjusting the distance between grouped objects. Defaults
to \code{0.8} for plots with at least one discrete axis and \code{0} for plots with two
continuous axes.}

\item{width}{Width of the bar.}

\item{saturation}{A \code{number} between \code{0} and \code{1} for the color saturation of an object. A value of \code{0} is completely desaturated (white), \code{1} is the original color.}

\item{preserve}{Should dodging preserve the \code{"total"} width of all elements at
a position, or the width of a \code{"single"} element?}

\item{...}{Arguments passed on to the \code{geom} function.}

\item{linewidth}{Thickness of the line in points (pt). Typical values range between \code{0.25} and \code{1}.}

\item{size}{A \code{number} representing the size of the plot symbol. Typical
values range between \code{1} and \code{3}.}

\item{accuracy}{A number to round to. Use (e.g.) \code{0.01} to show 2 decimal
places of precision. If \code{NULL}, the default, uses a heuristic that should
ensure breaks have the minimum number of digits needed to show the
difference between adjacent values.

Applied to rescaled data.}

\item{scale_cut}{Scale cut function to be applied. See \code{scales::cut_short_scale()} and friends.}

\item{fontsize}{Font size in points. Defaults to \code{7}.}

\item{extra_padding}{Extra padding to create space for the value label.}

\item{vjust}{Vertical position adjustment of the value label.}

\item{hjust}{Horizontal position adjustment of the value label.}

\item{group}{Variable in the dataset to be used for grouping.}
}
\value{
A \code{tidyplot} object.
}
\description{
Add mean
}
\examples{
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_mean_bar()

study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_mean_dash()

study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_mean_dot()

study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_mean_value()

study |>
  tidyplot(x = treatment, y = score) |>
  add_mean_line()

study |>
  tidyplot(x = treatment, y = score) |>
  add_mean_area()

# Combination
study |>
  tidyplot(x = treatment, y = score) |>
  add_mean_bar(alpha = 0.4) |>
  add_mean_dash() |>
  add_mean_dot() |>
  add_mean_value() |>
  add_mean_line()

# Changing arguments: alpha
# Makes objects transparent
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  theme_minimal_y() |>
  add_mean_bar(alpha = 0.4)

# Changing arguments: saturation
# Reduces fill color saturation without making the object transparent
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  theme_minimal_y() |>
  add_mean_bar(saturation = 0.3)

# Changing arguments: accuracy
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_mean_value(accuracy = 0.01)

# Changing arguments: fontsize
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_mean_value(fontsize = 10)

# Changing arguments: color
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_mean_value(color = "black")

}
