% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{tidyplot}
\alias{tidyplot}
\title{Create a new tidyplot}
\usage{
tidyplot(
  data,
  ...,
  width = NULL,
  height = NULL,
  unit = NULL,
  dodge_width = NULL,
  my_style = NULL,
  paper = NULL,
  ink = NULL
)
}
\arguments{
\item{data}{A tidy \code{data.frame} to use for plotting.}

\item{...}{Mappings for the \code{x} axis, \code{y} axis and \code{color}, see examples.
Additional argument are passed to \code{ggplot2::aes()}.}

\item{width, height}{Dimensions of the plot area. The default (\code{NULL}) retrieves the setting from the
\link[=tidyplots_options]{tidyplots options}, which defaults to \code{50}. \code{NA} results in taking all available space (ggplot2 default).}

\item{unit}{Unit of the plot area width and height. The default (\code{NULL}) retrieves the setting from the
\link[=tidyplots_options]{tidyplots options}, which defaults to \code{"mm"}.}

\item{dodge_width}{For adjusting the distance between grouped objects.
The default (\code{NULL}) retrieves the setting from the
\link[=tidyplots_options]{tidyplots options}, which defaults to \code{0.8} for plots with
at least one discrete axis and to \code{0} for plots with two continuous axes.}

\item{my_style}{Styling function to apply to the plot. The default (\code{NULL}) retrieves the setting from the
\link[=tidyplots_options]{tidyplots options}, which default to no additional styling.}

\item{paper}{Background color. The default (\code{NULL}) retrieves the setting from the
\link[=tidyplots_options]{tidyplots options}, which defaults to \code{"#FFFFFF"}.}

\item{ink}{Foreground color. The default (\code{NULL}) retrieves the setting from the
\link[=tidyplots_options]{tidyplots options}, which defaults to \code{"#000000"}.}
}
\description{
Create a new tidyplot
}
\examples{
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_data_points_beeswarm()

study |>
  tidyplot(x = group, y = score, color = dose) |>
  add_mean_bar()

# Change plot area size
study |>
  tidyplot(x = treatment, y = score, color = treatment,
    width = 25, height = 25) |>
  add_data_points_beeswarm()

# Change dodge_width
study |>
  tidyplot(x = group, y = score, color = dose, dodge_width = 0.3) |>
  add_mean_bar()

}
