% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_data.R
\name{prep_data}
\alias{prep_data}
\title{Prepare Data for tidyrhrv Functions}
\usage{
prep_data(.data, time, HR, RR)
}
\arguments{
\item{.data}{A nested data frame from read_tilt function}

\item{time}{A character string specifying the name of the time column}

\item{HR}{A character string specifying the name of the heart rate column}

\item{RR}{A character string specifying the name of the RR interval column}
}
\value{
A nested data frame with standardized column names (Time, niHR, RR)
}
\description{
This function helps to manipulate the data into a dataset readable by
other tidyrhrv functions by standardizing column names.
}
\examples{
# Create toy HRV data
temp_dir <- tempdir()

# Generate synthetic data with different column names to demonstrate prep_data
time_seq <- seq(0, 30, by = 0.8)
hrv_data <- data.frame(
  time_col = time_seq,
  heart_rate = 75 + rnorm(length(time_seq), 0, 5),
  rr_interval = 60/75 + rnorm(length(time_seq), 0, 0.1)
)

# Write toy data file
write.csv(hrv_data, file.path(temp_dir, "test_subject.csv"), row.names = FALSE)

# Read the data using read_tilt
raw_data <- read_tilt(temp_dir, read.csv)

# Prepare data with standardized column names
prepped_data <- prep_data(raw_data, "time_col", "heart_rate", "rr_interval")

# Check the standardized column names
print(names(prepped_data$contents[[1]]))

# Clean up
unlink(file.path(temp_dir, "test_subject.csv"))
}
