% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neg_log.R
\name{neg_log}
\alias{neg_log}
\alias{neglog}
\title{Negative Logarithm (Base 10 by Default)}
\usage{
neg_log(x, base = 10)

neglog(x, base = 10)
}
\arguments{
\item{x}{A numeric vector. Values must be positive.}

\item{base}{A numeric value specifying the base of the logarithm. Default is 10.}
}
\value{
A numeric vector of negative logarithmic values.
}
\description{
Computes the negative logarithm of a numeric input using base 10 by default.
}
\details{
This function returns the negative logarithm of `x`. By default, it uses base 10, but you can specify a different base using the `base` argument. Designed for quickly transforming p values for statistical analysis.
}
\examples{
pvals <- 10^runif(10, -15, -1)
neg_log(pvals)
}
