% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_read.R
\name{spec_read}
\alias{spec_read}
\title{Read Spectral Data from Various File Formats}
\usage{
spec_read(file, wn_col, ...)
}
\arguments{
\item{file}{Path to the file to be read.}

\item{wn_col}{Character. Name of the column containing wavenumber values. This column
will be set as the default wavenumber column.}

\item{...}{Additional arguments passed to `readr::read_delim()`, `readr::read_csv()`,
or `readxl::read_excel()`, depending on the file format.}
}
\value{
A tibble containing the spectral data.
}
\description{
This function reads spectral data from a file, automatically detecting the format
and using either `readr` or `readxl` functions. It also sets the specified
wavenumber column as the default using `set_spec_wn()`.
}
\details{
The function automatically determines the file format based on the extension:
  - `.txt`, `.csv`, `.tsv`, and `.csv2` are read using `readr` functions.
  - `.xls` and `.xlsx` are read using `readxl::read_excel()`.

  If the specified `wn_col` does not exist in the data, an error is returned.
}
\examples{
\donttest{
  file_path <- system.file("extdata", "CoHAspec.csv", package = "tidyspec")
  df <- spec_read(file_path, wn_col = "Wavenumber")
  check_wn_col() # Verifica se a coluna de wavenumber está definida
}
}
