% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visit_sequence_api.R
\name{add_sequence_numeric}
\alias{add_sequence_numeric}
\title{Add to visit sequence for numeric variables}
\usage{
add_sequence_numeric(
  roadmap,
  ...,
  method = c("correlation", "proportion", "weighted total", "absolute weighted total",
    "weighted absolute total"),
  cor_var = NULL,
  na.rm = FALSE,
  cor_use = "everything"
)
}
\arguments{
\item{roadmap}{A \code{roadmap} object}

\item{...}{\verb{<tidy-select>} One or more unquoted expressions separated by
commas. Variable names can be used as if they were positions in the data
frame, so expressions like x:y can be used to select a range of variables.}

\item{method}{A quoted name for the method used to sort the visit_sequence}

\item{cor_var}{A numeric variable for the correlation method}

\item{na.rm}{Boolean that if TRUE, removes \code{NA} values from computations}

\item{cor_use}{A string correlation data method passed to \code{stats::cor} if using.
If \code{na.rm == TRUE} then defaults to \code{complete.obs}. See \code{?stats::cor} for
more options.}
}
\value{
An updated visit_sequence
}
\description{
Add to visit sequence for numeric variables
}
\examples{

roadmap(
  conf_data = acs_conf_nw, 
  start_data = acs_start_nw
) |>
  add_sequence_numeric(
    dplyr::where(is.numeric), 
    method = "correlation", 
    cor_var = "age",
    na.rm = TRUE
  )

}
