% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_feed_by_date}
\alias{filter_feed_by_date}
\title{Filter a gtfs feed so that it only contains trips running on a given date}
\usage{
filter_feed_by_date(
  gtfs_obj,
  extract_date,
  min_departure_time,
  max_arrival_time
)
}
\arguments{
\item{gtfs_obj}{gtfs feed (tidygtfs object)}

\item{extract_date}{date to extract trips from this day (Date or "YYYY-MM-DD" string)}

\item{min_departure_time}{(optional) The earliest departure time. Can be given as "HH:MM:SS",
hms object or numeric value in seconds.}

\item{max_arrival_time}{(optional) The latest arrival time. Can be given as "HH:MM:SS",
hms object or numeric value in seconds.}
}
\value{
tidygtfs object with filtered tables
}
\description{
Only stop_times, stops, routes, services (in calendar and calendar_dates), shapes,
frequencies and transfers belonging to one of those trips are kept.
}
\seealso{
\code{\link[=filter_feed_by_area]{filter_feed_by_area()}}, \code{\link[=filter_feed_by_stops]{filter_feed_by_stops()}}, \code{\link[=filter_feed_by_trips]{filter_feed_by_trips()}}
}
