% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_breaks_n.R
\name{date_breaks_n}
\alias{date_breaks_n}
\title{Create evenly spaced breaks}
\usage{
date_breaks_n(dates, n = 6, decreasing = TRUE)
}
\arguments{
\item{dates}{A vector of dates.}

\item{n}{Integer, keep every n-th date (default = 6).}

\item{decreasing}{Logical, if TRUE (default) sorts dates in descending order.}
}
\value{
A vector of dates suitable for use as ggplot2 axis breaks.
}
\description{
Generate a sequence of date breaks for ggplot scales,
taking every \code{n}th unique date.
}
\examples{
library(ggplot2)
library(dplyr)

df <- tibble(
  date = seq.Date(as.Date("2020-01-01"), as.Date("2025-01-01"), by = "month"),
  value = rnorm(61)
)

ggplot(df, aes(date, value)) +
  geom_line() +
  scale_x_date(breaks = date_breaks_n(df$date, 6))
}
