% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blend_waters.R
\name{blend_waters}
\alias{blend_waters}
\alias{blend_waters_df}
\title{Determine blended water quality from multiple waters based on mass balance and acid/base equilibrium}
\usage{
blend_waters(waters, ratios)

blend_waters_df(df, waters, ratios, output_water = "blended")
}
\arguments{
\item{waters}{Vector of source waters created by \link{define_water}. For \code{df} function, this can include
quoted column names and/or existing single water objects unquoted.}

\item{ratios}{Vector of ratios in the same order as waters. (Blend ratios must sum to 1). For \code{df} function,
this can also be a list of quoted column names.}

\item{df}{a data frame containing a water class column, which has already been computed using \link{define_water_df}}

\item{output_water}{name of output column storing updated parameters with the class, water. Default is "blended_water".}
}
\value{
\code{blend_waters} returns a water class object with blended water quality parameters.

\code{blend_waters_df} returns a data frame with a water class column containing blended water quality
}
\description{
This function takes a vector of waters defined by \link{define_water}
and a vector of ratios and outputs a new water object with updated ions and pH.
For a single blend use \code{blend_waters}; for a dataframe use \code{blend_waters_df}.
Use \link{pluck_water} to get values from the output water as new dataframe columns.
}
\examples{
water1 <- define_water(7, 20, 50)
water2 <- define_water(7.5, 20, 100, tot_nh3 = 2)
blend_waters(c(water1, water2), c(.4, .6))


example_df <- water_df \%>\%
  dplyr::slice_head(n = 3) \%>\%
  define_water_df() \%>\%
  chemdose_ph_df(naoh = 22) \%>\%
  dplyr::mutate(
    ratios1 = .4,
    ratios2 = .6
  ) \%>\%
  blend_waters_df(
    waters = c("defined", "dosed_chem"),
    ratios = c("ratios1", "ratios2"), output_water = "Blending_after_chemicals"
  )

\donttest{
waterA <- define_water(7, 20, 100, tds = 100)
example_df <- water_df \%>\%
  dplyr::slice_head(n = 3) \%>\%
  define_water_df() \%>\%
  blend_waters_df(waters = c("defined", waterA), ratios = c(.8, .2))
}

}
\seealso{
\link{define_water}
}
