% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_user_agent_settings.R
\name{tw_set_user_agent}
\alias{tw_set_user_agent}
\alias{tw_get_user_agent}
\title{Set language to be used by all functions}
\usage{
tw_set_user_agent(user_agent = NULL)

tw_get_user_agent(user_agent = NULL)
}
\arguments{
\item{user_agent}{Defaults to \code{NULL}. If not given, implicitly defaults to
current package name (\code{tidywikidatar}) and version.}
}
\value{
The user agent set for the session, implicitly.
}
\description{
Defaults to current package name (\code{tidywikidatar}) and version.
}
\examples{
# Default user agent
default_user_agent <- tw_get_user_agent()
default_user_agent
# Custom user agent
tw_set_user_agent(user_agent = "custom_project_name/email")
new_user_agent <- tw_get_user_agent()
new_user_agent
# Restore
tw_set_user_agent(user_agent = default_user_agent)
tw_get_user_agent()
}
