% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoSampleAalenJohansen.R
\name{TwoSampleAalenJohansen}
\alias{TwoSampleAalenJohansen}
\title{Risk difference and ratio using the Aalen-Johansen method}
\usage{
TwoSampleAalenJohansen(
  time,
  cause,
  group,
  t,
  RR.H0 = 1,
  Diff.H0 = 0,
  level = 0.95,
  contr = list(tol = 1e-05, algo = 2, k = 3, Trace = FALSE, method = "both")
)
}
\arguments{
\item{time}{vector of times (possibly censored)}

\item{cause}{vector of event types/causes. It should be coded 1 for main events, 2 for competing events and 0 for censored.}

\item{group}{vector of binary group indicator. The reference group should be coded 0, the other 1.}

\item{t}{the time point of interest (e.g. 1 to compute a 1-year risk ratio)}

\item{RR.H0}{the risk ratio under the null hypothesis, to compute a p-value. Default is 1.}

\item{Diff.H0}{the risk difference under the null hypothesis, to compute a p-value. Default is 0.}

\item{level}{confidence level for the confidence intervals. Default is 0.95.}

\item{contr}{list of control parameters. tol=tolerance for numerical computation, default is 1e-5. method="EL", "Wald" or "both"  indicates wether 95\% CI and the p-value should be computed based on Empirical Likelihood (EL) inference, Wald-type inference or both. algo=2 (default) or 1, depending on which computational method should be used to maximize the empirical likelihood (method 1 or 2, as described in Blanche & Eriksson (2023))}
}
\value{
an object of class 'TwoSampleAalenJohansen'
}
\description{
Computes an (absolute) risk difference or ratio with right-censored competing risks data, together with a confidence interval and a
p-value (to test for a difference between the two risks). Pointwise estimates are computed via the Aalen-Johansen estimator. Computation of confidence intervals
and p-values are based on either Empirical Likelihood (EL) inference or Wald-type inference. Both are non-parametric approaches, which are asymptotically equivalent.
For the Wald-type approach, the asymptotic normal approximation is used on the log scale for the risk ratio. No transformation is used for the risk difference.
See Blanche & Eriksson (2023) for details.
}
\examples{
## A simple example for Wald-type inference, using simulated data.
## It illustrates the possible inconsistency of Wald-type inference, in
## terms of statistical significance, when inference is based on the risk
## ratio and on the risk difference. This inconsistency cannot exist
## using an empirical likelihood approach.

ResSimA100 <- TwoSampleAalenJohansen(time=SimA100$time,
                                     cause=SimA100$status,
                                     group=SimA100$group,
                                     t=1,
                                     contr=list(method="Wald"))
ResSimA100

\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Same example data, but now analyzed with and empirical likelihood approach. It
## takes approx 20 seconds to run.

ResSimA100 <- TwoSampleAalenJohansen(time=SimA100$time,
                                     cause=SimA100$status,
                                     group=SimA100$group,
                                     t=1)
ResSimA100

\dontshow{\}) # examplesIf}
}
\references{
Blanche & Eriksson (2023). Empirical likelihood comparison of absolute risks.
}
\author{
Paul Blanche
}
