% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{sunspotarea_ts}
\alias{sunspotarea_ts}
\title{Annual Average Sunspot Area}
\format{
A `ts` object with 141 observations:
\describe{
  \item{time}{Annual time series from 1875 to 2015.}
  \item{value}{Average sunspot area observed per year (in millionths of the solar disk).}
}
}
\source{
NASA's Solar Dynamics Observatory.
}
\usage{
data(sunspotarea_ts)
}
\description{
The dataset name has been changed to 'sunspotarea_ts' to avoid confusion with other datasets
in the R ecosystem from which data have been sourced. The suffix 'ts' indicates that this dataset
is a time series object. This naming convention helps distinguish this dataset as part of the
'timeseriesdatasets' package and assists users in identifying its specific characteristics. The original content
of the dataset has not been modified in any way.
}
\details{
This dataset contains annual data on the average sunspot area observed from 1875 to 2015. Sunspot area measurements indicate the size of sunspots on the Sun's surface.
}
\keyword{datasets}
