
# timeseriesdatasets package, a collection of time series data sets for R.
# Copyright (C) 2024  Renzo Caceres Rossi
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# data set BJsales_ts

library(testthat)

# library(timeSeriesDataSets) activate the timeSeriesDataSets package

# Test that the object 'BJsales_ts' has the correct class

test_that("BJsales_ts has the correct class of object", {
  # Check if 'BJsales_ts' is of class 'ts'

  expect_equal(class(BJsales_ts), "ts")
})


# Test that 'BJsales_ts' has the correct number of observations

test_that("BJsales_ts has the correct number of observations", {
  # Verify that the length of 'BJsales_ts' matches the expected number of observations

  expect_equal(length(BJsales_ts), 150)
})


# Test that 'BJsales_ts' has the correct frequency

test_that("BJsales_ts has the correct frequency", {
  # Check if the frequency of 'BJsales_ts' is 1 (annual data or non-seasonal)

  expect_equal(frequency(BJsales_ts), 1)
})



# Test that 'BJsales_ts' has the correct start and end times

test_that("BJsales_ts has the correct start and end", {
  # Verify that 'BJsales_ts' starts at the first time period
  expect_equal(start(BJsales_ts), c(1, 1))

  # Verify that 'BJsales_ts' ends at the 150th time period
  expect_equal(end(BJsales_ts), c(150, 1))
})



test_that("BJsales_ts does not contain missing values", {
  # Check for NA values in the dataset
  expect_false(any(is.na(BJsales_ts)))
})



