% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrap_cliques}
\alias{bootstrap_cliques}
\alias{bootstrap_cliques.tna}
\title{Bootstrap Cliques of Transition Networks from Sequence Data}
\usage{
bootstrap_cliques(x, size, threshold, iter, level, consistency_range)

\method{bootstrap_cliques}{tna}(
  x,
  size = 2L,
  threshold = 0,
  iter = 1000,
  level = 0.05,
  consistency_range = c(0.75, 1.25)
)
}
\arguments{
\item{x}{A \code{tna} or a \code{group_tna} object.}

\item{size}{An \code{integer} specifying the size of the cliques to identify.
Defaults to \code{2} (dyads).}

\item{threshold}{A \code{numeric} value that sets the minimum edge weight
for an edge to be considered in the clique. Edges below this value
are ignored. Defaults to \code{0}.}

\item{iter}{An \code{integer} specifying the number of bootstrap samples to
draw. Defaults to \code{1000}.}

\item{level}{A \code{numeric} value representing the significance level for
hypothesis testing and confidence intervals. Defaults to \code{0.05}.}

\item{consistency_range}{A \code{numeric} vector of length 2. Determines how much
the edge weights may deviate (multiplicatively) from their observed values
(below and above) before they are considered insignificant. The default is
\code{c(0.75, 1.25)} which corresponds to a symmetric 25\% deviation range. Used
only when \code{method = "stability"}.}
}
\description{
Bootstrap Cliques of Transition Networks from Sequence Data
}
