% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.summary.tna_bootstrap}
\alias{print.summary.tna_bootstrap}
\title{Print a Bootstrap Summary}
\usage{
\method{print}{summary.tna_bootstrap}(x, ...)
}
\arguments{
\item{x}{A \code{summary.tna_bootstrap} object.}

\item{...}{Arguments passed to the generic \code{print} method.}
}
\value{
A \code{summary.tna_bootstrap} object (invisibly) containing the weight,
estimated p-value and confidence interval of each edge.
}
\description{
Print a Bootstrap Summary
}
\examples{
model <- tna(group_regulation)
# Small number of iterations for CRAN
boot <- bootstrap(model, iter = 10)
print(summary(boot))

}
\seealso{
Validation functions
\code{\link{bootstrap}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{permutation_test}()},
\code{\link{permutation_test.group_tna}()},
\code{\link{plot.group_tna_bootstrap}()},
\code{\link{plot.group_tna_permutation}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{plot.tna_bootstrap}()},
\code{\link{plot.tna_permutation}()},
\code{\link{plot.tna_stability}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_permutation}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{print.tna_bootstrap}()},
\code{\link{print.tna_permutation}()},
\code{\link{print.tna_stability}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna_bootstrap}()},
\code{\link{summary.tna_bootstrap}()}
}
\concept{validation}
