% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_datasets}
\alias{get_datasets}
\title{List Available Datasets}
\usage{
get_datasets(
  keyword = NULL,
  author = NULL,
  organization = NULL,
  max_results = 100
)
}
\arguments{
\item{keyword}{Character. Keyword to search for in dataset titles.}

\item{author}{Character. Author name to filter datasets by.}

\item{organization}{Character. Organization name to filter datasets by.}

\item{max_results}{Numeric. Maximum number of datasets to return, defaults
to 100.}
}
\value{
A tibble (data frame) with the following columns:
\describe{
\item{title}{Character. Title of the dataset.}
\item{id}{Character. ID of the dataset.}
\item{resources}{List. A list of tibbles with the following columns:
\describe{
\item{name}{Character. Name of the dataset.}
\item{format}{Character. Format of the dataset.}
\item{url}{Character. URL of the dataset.}
}
}
\item{created}{Date. Date the dataset was created.}
}
}
\description{
Fetches datasets by keyword and/or author
}
\examples{
try({
  datasets <- get_datasets("agriculture")
  head(datasets)
})

}
