% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/editor.R
\name{editor}
\alias{editor}
\title{Create an interactive editor}
\usage{
editor(
  ...,
  getMarkdownOnChange = TRUE,
  getHTMLOnChange = TRUE,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{...}{Options for the editor, see examples or \href{https://nhn.github.io/tui.editor/latest/ToastUIEditorCore/}{online reference}.}

\item{getMarkdownOnChange, getHTMLOnChange}{Get editor's content in Shiny application through an input value : \verb{input$<outputId>_(markdown|html)}.}

\item{height, width}{Height and width for the chart.}

\item{elementId}{An optional id.}
}
\value{
An \code{editor} htmlwidget.
}
\description{
Create an interactive editor
}
\examples{
# Default is markdown editor with tab to switch to preview
editor()
# equivalent to
editor(previewStyle = "tab")
# Show preview side by side
editor(previewStyle = "vertical")

# Default edit type is markdown
editor(initialEditType = "markdown")
# Change to wysiwyg and remove switch mode option
editor(initialEditType = "wysiwyg", hideModeSwitch = TRUE)

# i18n : change language
editor(language = "fr")
editor(language = "ar")
# see https://github.com/nhn/tui.editor/blob/master/docs/en/i18n.md for other supported languages
}
