% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{parameters}
\alias{parameters}
\title{Parameters of agents from a graph}
\usage{
parameters(g)
}
\arguments{
\item{g}{\code{toporanga_graph} object generated from tally.}
}
\value{
A \code{data.frame} object.
Each of its rows corresponds to one agent.
This agent's ID is listed in the \code{Agent} column.
\code{Superiors} counts the number of agents which are upstream from a given agent, while \code{Subordinates} counts those downstream.
This numbers correspond to a rank when when there is only one unique toposort of the dominance graph, and provide a graceful degradation if not.
In particular they do not depend on random seed or the default toposort stored in the graph object.
Thus, subordinate count is a recommended outcome if a single dominance score of an agent is desired.
The \code{Order} column notes the aforementioned default toposort, which can be re-sampled with the \code{sample_toposort}.
Additional columns may appear depending on meta-data in the graph object, in particular epoch parameters when using \code{epoch} argument of \code{toporanga} function.
}
\description{
Pull numerical descriptors of a toporanga graph.
}
