#include <stdint.h>
#include <stdbool.h>
#include <math.h>

void floyd_warshall(double *in,uint32_t c,double *ans){
  for(uint32_t e=0;e<c*c;e++) ans[e]=in[e];
  for(uint32_t e=0;e<c;e++) ans[e+c*e]=0.;
  for(uint32_t e=0;e<c;e++)
    for(uint32_t ee=0;ee<c;ee++)
      for(uint32_t eee=0;eee<c;eee++)
        if(eee!=ee && e!=ee && e!=eee){
          double indirect=fmin(ans[ee*c+e],ans[e*c+eee]);
          ans[ee*c+eee]=fmax(ans[ee*c+eee],indirect);
        }
  
}

void hsu(uint32_t *in,uint32_t c,uint32_t *ans){
  for(uint32_t e=0;e<c*c;e++) ans[e]=in[e];
  for(uint32_t e=0;e<c;e++) ans[e+c*e]=0;
  for(uint32_t e=0;e<c;e++)
    for(uint32_t ee=0;ee<c;ee++)
      if(ans[ee*c+e])
        for(uint32_t eee=0;eee<c;eee++)
          if(eee!=ee && e!=ee && e!=eee)
            if(ans[e*c+eee])
              ans[ee*c+eee]=false;
}
