% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-oxfordiiitpet.R
\name{oxfordiiitpet_segmentation_dataset}
\alias{oxfordiiitpet_segmentation_dataset}
\title{Oxford-IIIT Pet Segmentation Dataset}
\usage{
oxfordiiitpet_segmentation_dataset(
  root = tempdir(),
  train = TRUE,
  target_type = "category",
  transform = NULL,
  target_transform = NULL,
  download = FALSE
)
}
\arguments{
\item{root}{Character. Root directory where the dataset is stored or will be downloaded to. Files are placed under \code{root/oxfordiiitpet}.}

\item{train}{Logical. If TRUE, use the training set; otherwise, use the test set. Not applicable to all datasets.}

\item{target_type}{Character. One of \code{"category"} or \code{"binary-category"} (default: \code{"category"}).}

\item{transform}{Optional. A function that takes an image and returns a transformed version (e.g., normalization, cropping).}

\item{target_transform}{Optional. A function that transforms the label.}

\item{download}{Logical. If TRUE, downloads the dataset to \verb{root/}. If the dataset is already present, download is skipped.}
}
\value{
A torch dataset object \code{oxfordiiitpet_dataset}. Each item is a named list:
\itemize{
\item \code{x}: a H x W x 3 integer array representing an RGB image.
\item \code{y$masks}: a boolean tensor of shape (3, H, W), representing the segmentation trimap as one-hot masks.
\item \code{y$label}: an integer representing the class label, depending on the \code{target_type}:
\itemize{
\item \code{"category"}: an integer in 1–37 indicating the pet breed.
\item \code{"binary-category"}: 1 for Cat, 2 for Dog.
}
}
}
\description{
The Oxford-IIIT Pet Dataset is a \strong{segmentation} dataset consisting of color images
of 37 pet breeds (cats and dogs). Each image is annotated with a pixel-level
trimap segmentation mask, identifying pet, background, and outline regions.
It is commonly used for evaluating models on object segmentation tasks.
}
\examples{
\dontrun{
# Load the Oxford-IIIT Pet dataset with basic tensor transform
oxfordiiitpet <- oxfordiiitpet_segmentation_dataset(
   transform = transform_to_tensor,
   download = TRUE
)

# Retrieve the image tensor, segmentation mask and label
first_item <- oxfordiiitpet[1]
first_item$x  # RGB image tensor of shape (3, H, W)
first_item$y$masks   # (3, H, W) bool tensor: pet, background, outline
first_item$y$label  # Integer label (1–37 or 1–2 depending on target_type)
oxfordiiitpet$classes[first_item$y$label] # Class name of the label

# Visualize
overlay <- draw_segmentation_masks(first_item)
tensor_image_browse(overlay)
}

}
\seealso{
Other segmentation_dataset: 
\code{\link{pascal_voc_datasets}},
\code{\link{rf100_peixos_segmentation_dataset}()}
}
\concept{segmentation_dataset}
