% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getECx.R
\name{getECx}
\alias{getECx}
\title{Get point estimates from model}
\usage{
getECx(
  dataset,
  model,
  EDx = 0.5,
  interval = c("tfls", "fls", "delta", "none"),
  level = 0.95,
  type = c("absolute", "relative"),
  quiet = FALSE,
  EDargs.supplement = list(),
  list_obj = NULL
)
}
\arguments{
\item{dataset}{A dataframe used to generate `model`.}

\item{model}{A drm model, generated by `modelcomp()` or `drm()`.}

\item{EDx}{Numeric. The effective dose level to estimate. Defaults
to 0.5.}

\item{interval}{Character. Method for calculating confidence intervals
of EDx. Choices: `"tfls"`, `"fls"`, `"delta"`, `"none"`. Defaults
to "tfls". See `drc::ED()` for more information.}

\item{level}{Numeric. Confidence level for the interval calculation.
Defaults to 0.95.}

\item{type}{Character. Indicates if EDx is `"absolute"` or
`"relative"` to the curve. Defaults to absolute.}

\item{quiet}{Logical. Indicates if results should be hidden. Defaults
to FALSE.}

\item{EDargs.supplement}{List. Optional user-supplied list of additional arguments
compatible with `drc::ED()`.}

\item{list_obj}{Optional. List object used for integration with
[runtoxdrc()].}
}
\value{
A dataframe of the point estimates. If `list_obj` is provided, returns
 this within a list as `list_obj$effectmeasure`.
}
\description{
Generate point estimates from a dose response curve.
}
