% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeoutliers.R
\name{removeoutliers}
\alias{removeoutliers}
\title{Remove outliers iteratively using Grubbs' test.}
\usage{
removeoutliers(dataset, Conc, Response, list_obj = NULL, quiet = FALSE)
}
\arguments{
\item{dataset}{A dataframe, containing the columns `Conc` and `Response`.}

\item{Conc}{Bare (unquoted) column name in `dataset` that groups the
`Response` variable.}

\item{Response}{Bare (unquoted) column name in `dataset` containing
the response variable.}

\item{list_obj}{Optional. List object used for integration with
[runtoxdrc()].}

\item{quiet}{Logical. Indicates if results should be hidden. Defaults
to FALSE.}
}
\value{
A modified `dataset` with outliers removed. If
 `list_obj` is provided, returns this within a list as
 `list_obj$dataset`, along with dataframe of removed outliers as
 `list_obj$removed_outliers`.
}
\description{
This function removes statistical outliers from each testing group by iteratively applying Grubbs' test.
}
\examples{
df <- data.frame(x = rep(1:2, each = 3),y = c(3, 5, 7, 3, 4, 30))
removeoutliers(dataset = df, Conc = x, Response = y)

}
