% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate_qsf.R
\name{translate.qsf}
\alias{translate.qsf}
\title{Translate iatgen generated QSF file}
\usage{
translate.qsf(file, lang, lang_file = NULL, src_lang = "en", dst_file = NULL)
}
\arguments{
\item{file}{qsf file}

\item{lang}{Target language (abbreviation).}

\item{lang_file}{CSV file containing custom translation.}

\item{src_lang}{Source language -- "en" for english is the only supported one.}

\item{dst_file}{save the translated file as. If NULL temporary file will be created.}
}
\value{
Translated file path/location (class: character)
}
\description{
Read-in iatgen generated QSF file and translated it to a target language
specified by user either from the list of available languages included
in tr.iatgen package or using the custom supplied translation file.
}
\examples{
# example code
my_qsf_file <- system.file("examples/iat-flowins.qsf", package = "tr.iatgen")
translate.qsf(file = my_qsf_file, lang = "pt-pt")

}
