% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{size_table_to_fragments}
\alias{size_table_to_fragments}
\title{Convert Size Table to Fragments}
\usage{
size_table_to_fragments(df, min_size_bp = 200, max_size_bp = 1000)
}
\arguments{
\item{df}{A data frame containing the size data with the columns "unique_id", "size", "signal".}

\item{min_size_bp}{Numeric value indicating the minimum size of the peak table to import.}

\item{max_size_bp}{Numeric value indicating the maximum size of the peak table to import.}
}
\value{
A list of fragments objects.
}
\description{
This function converts a size table data frame into a list of fragments. class.
}
\details{
This function takes a size table data frame and converts it into a list of fragments objects. The column names must be "unique_id" (unique sample id), "size" (base pair size), and "signal" (the signal associated with fragment). The dataframe should be long (eg bind rows if the data are separate).
}
\examples{
size_table <- trace::example_data
colnames(size_table)[c(2, 5, 6)] <- c("unique_id", "size", "signal")
fragments_list <- size_table_to_fragments(size_table)
}
\seealso{
\code{\link[=repeat_table_to_fragments]{repeat_table_to_fragments()}}, \code{\link[=size_table_to_fragments]{size_table_to_fragments()}}, \code{\link[=read_fsa]{read_fsa()}}
}
