% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indEffectTest.R
\name{indEffectTest}
\alias{indEffectTest}
\title{Test site fidelity}
\usage{
indEffectTest(
  tracks,
  tripID,
  groupVar,
  plot = TRUE,
  method = c("HR", "PHR", "VI", "BA", "UDOI", "HD"),
  conditional = TRUE,
  levelUD = 50,
  scale,
  grid = 500,
  iterations = 1000
)
}
\arguments{
\item{tracks}{SpatialPointsDataFrame. Must be projected into an equal-area 
coordinate system. If not, first run \code{\link{projectTracks}}.}

\item{tripID}{character. Column in \emph{tracks} corresponding to the within 
group ID (e.g. trip-individual combination)}

\item{groupVar}{character. Column in \emph{tracks} corresponding to the 
between group ID (e.g. individual or track)}

\item{plot}{logical scalar (TRUE/FALSE). Do you want to output a boxplot of 
the result?}

\item{method}{character. Which method of overlap estimation to use? See 
\code{\link[adehabitatHR]{kerneloverlap}} for descriptions of each method.}

\item{conditional}{logical scalar (T/F). If TRUE, the function sets to 0 the
pixels of the grid over which the UD is estimated, outside the home range of
 the animal estimated at a level of probability equal to percent. Note that
  this argument has no effect when meth="HR" 
  (from \code{\link[adehabitatHR]{kerneloverlap}}).}

\item{levelUD}{numeric. The desired contour level of the utilization 
distribution to be used in overlap estimation. NOTE: this is irrelevant if 
\emph{conditional=FALSE}.}

\item{scale}{numeric (in kilometers). Smoothing ('H') parameter for 
kernel density estimation.}

\item{grid}{numeric or SpatialPixels. If numeric, specify the desired number 
of grid cells over which the utilization distributions will be esimated. 
A default grid of 500 cells is used.}

\item{iterations}{numeric. Indicate the desired number of Kolmogorov-Smirnov 
iterations to run. 500 is an advisable minimum for statistical rigor.}
}
\value{
\code{indEffectTest} returns a list containing three objects. In the 
first slot 'Overlap Matrix', the full matrix of overlap comparisons. In the '
Overlap' slot, a dataframe with a column identifying whether each overlap 
estimate corresponds to a within-group, or a between-group comparison. 
In the third slot 'Kolmogorov-Smirnov' is the test output of the 
Kolmogorov-Smirnov test, indicating the D parameter and significance 
estimates.
}
\description{
\code{indEffectTest} tests whether the variance in overlap between space use 
areas within a group (e.g within individuals) is significant compared to 
between groups (e.g. between individuals).
}
\details{
This function works by producing kernel density areas at a desired contour 
level (i.e. \emph{UDLEv}) for each level of \emph{tripID} and estimating the 
degree of overlap between all pairwise comparisons using the desired overlap 
\emph{method}. Then, comparisons are split into 'within' and 'between' 
groups, determined by the grouping variable (i.e \emph{groupVar}) argument.

If \emph{conditional=TRUE} then the overlap estimates will range from 0 to 
\emph{levelUD} (unless \emph{method="HR"}).

Then, the empirical distribution of each group is compared in a bootstrapped 
Kolmogorov-Smirnov test, to check whether differences in the distributions 
are significant. If so, it indicates that individuals within the 
\emph{groupVar} reuse sites more than expected by chance.

NOTE: Because \code{indEffectTest} relies on 
\code{\link[adehabitatHR]{kerneloverlap}} to estimate overlap, it was not 
possible to implement a \emph{res} argument as is done in other track2KBA 
functions. Therefore, it is advised to either leave the default of 500 cells,
 or ascertain the number of cells in the grid of chosen \emph{res} from the 
 output of \link{estSpaceUse}.
}
\examples{
tracks_raw <- track2KBA::boobies
## format data
tracks_formatted <- formatFields(
  dataGroup = tracks_raw,
  fieldID   = "track_id",
  fieldLat  ="latitude",
  fieldLon  ="longitude",
  fieldDate ="date_gmt",
  fieldTime ="time_gmt"
)
\dontshow{
library(dplyr)
  tracks_formatted <- subset(
  tracks_formatted, ID \%in\% c("69324", "69302")
  ) \%>\% 
    dplyr::filter(dplyr::row_number() \%\% 20 == 1)
}
colony <- data.frame(
  Longitude = tracks_formatted$Longitude[1], 
  Latitude = tracks_formatted$Latitude[1]
)
## Split into trips
Trips <- tripSplit(tracks_formatted,
                   colony=colony,
                   innerBuff=2,
                   returnBuff=20,
                   duration=1,
                   nests = FALSE,
                   rmNonTrip = TRUE
)
## project dataset
tracks_prj <- projectTracks(
  Trips,
  projType = "azim",
  custom = "TRUE"
)
## estimate fidelity of individuals across trips
result <- indEffectTest(
  tracks_prj, 
  tripID = "tripID", 
  groupVar = "ID", 
  scale = 30
)

}
