% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth.R
\name{smooth_terms.LmME}
\alias{smooth_terms.LmME}
\title{Evaluate smooth terms of a \code{LmME} model.}
\usage{
\method{smooth_terms}{LmME}(object, as.lm = FALSE, k = 100, newdata = NULL, ...)
}
\arguments{
\item{object}{A \code{tramME} object.}

\item{as.lm}{Logical; if \code{TRUE} return the rescaled values according to a LMM
parametrization.}

\item{k}{Integer, the number of points to be used to evaluate the smooth terms.
Ignored when \code{newdata} is supplied.}

\item{newdata}{A \code{data.frame} with new values for the smooth terms.
If \code{NULL}, the new data is set up based on the \code{model.frame} and
\code{k}. Smooths for which the supplied information in this input is incomplete
will be ignored.}

\item{...}{Optional arguments. \code{as.lm} is passed through this when it is necessary.}
}
\value{
A list of results from evaluating the smooth terms of the model.
}
\description{
Evaluate smooth terms of a \code{LmME} model.
}
\examples{
data("mcycle", package = "MASS")
fit <- LmME(accel ~ s(times), data = mcycle)
plot(smooth_terms(fit, as.lm = TRUE))
}
