% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-location.R
\name{range_format}
\alias{range_format}
\alias{range_parse}
\alias{range_is_parseable}
\title{Source Ranges}
\usage{
range_format(x = location())

range_parse(ranges = character())

range_is_parseable(ranges = character())
}
\arguments{
\item{x}{A \code{\link{Location}} object.}

\item{ranges}{A character vector of non-NA and non-empty values.
The ranges to extract pairs of indices (line, column) from.}
}
\value{
\code{\link[=range_format]{range_format()}} returns a character vector. It assumes that \code{x} is valid.

\code{\link[=range_parse]{range_parse()}} returns a list having the same length as \code{ranges}. Each
element is an integer vectors containing 4 non-NA values (unless the
underlying range is invalid).

\code{\link[=range_is_parseable]{range_is_parseable()}} returns a logical vector having the same length as
\code{ranges}.
}
\description{
Create, parse, and validate source ranges.
}
\details{
Ranges are \verb{Ln <int>, Col <int> @ Ln <int>, Col <int>} strings created on-the-fly from
\code{\link{Location}} objects for outputting purposes.
}
\seealso{
\code{\link{Location}},
\code{\link{ExportedLocation}},
}
\keyword{internal}
