% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{is_tree}
\alias{is_tree}
\title{Is \code{x} a tree?}
\usage{
is_tree(x)
}
\arguments{
\item{x}{\verb{[object]}

An object.}
}
\value{
\code{TRUE} if \code{x} is a \code{tree_sitter_tree}, otherwise \code{FALSE}.
}
\description{
Checks if \code{x} is a \code{tree_sitter_tree} or not.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "fn <- function() { 1 + 1 }"
tree <- parser_parse(parser, text)

is_tree(tree)

is_tree(1)
\dontshow{\}) # examplesIf}
}
