% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node_language}
\alias{node_language}
\title{Get a node's underlying language}
\usage{
node_language(x)
}
\arguments{
\item{x}{\verb{[tree_sitter_node]}

A node.}
}
\value{
A \code{tree_sitter_language} object.
}
\description{
\code{node_language()} returns the document text underlying a node.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "1 + foo"
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

node_language(node)
\dontshow{\}) # examplesIf}
}
