% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsforecast_1.3.0.R
\name{tsconvert}
\alias{tsconvert}
\title{Convert One-Dimensional Data to Time Series}
\usage{
tsconvert(x, t, frequency = NULL, format = NULL, x.name = NULL)
}
\arguments{
\item{x}{a univariate time series object or a numeric vector or matrix.}

\item{t}{a vector or list of time in which the series values were observed.}

\item{frequency}{the number of observations per unit of time. If omitted, R will identify the frequency based on the time vector specified in \code{t}. Default is \code{NULL}.}

\item{format}{time format specified for the variable provided in \code{t}. If omitted, R will identify this automatically. Default is \code{NULL}.}

\item{x.name}{name of the series. If omitted here, the series name found by \code{tsname()} will be taken over here. If \code{tsname()} is \code{NULL}, the variable name will be used instead. Default is \code{NULL}.}
}
\value{
\code{x} is returned as a `\code{ts}` object with the attributes `\code{tsp}` (start, end, and frequency of \code{x}), `\code{series.name}` (series name, \emph{optional}), and `\code{seasonal.cycle}` (time gap between series observations).
}
\description{
The function `\code{tsconvert}` is used to convert any one-dimensional vector/list into a time-series objects.
}
\details{
The function \code{tsconvert} is used to convert vectors/lists into time-series objects. These are vectors or matrices which inherit from class "ts" (and have additional attributes) and represent data sampled at equispaced points in time. Time series must have at least one observation, and although they need not be numeric there is very limited support for non-numeric series.

Argument \code{frequency} indicates the sampling frequency of the time series, with the default value 1 indicating one sample in each unit time interval. For example, one could use a value of 7 for frequency when the data are sampled daily, and the natural time period is a week, or 12 when the data are sampled monthly and the natural time period is a year. Values of 4 and 12 are assumed in (e.g.) print methods to imply a quarterly and monthly series respectively. Note that \code{frequency} does not need to be a whole number: for example, \code{frequency = 0.2} would imply sampling once every five time units.
}
\examples{
travellers <- tsconvert(x = airport$Travellers, t = airport$Date)
}
\seealso{
\link{attributes}
}
\author{
Ka Yui Karl Wu
}
